<?php
namespace UiCore\Settings;

defined('ABSPATH') || exit();

/**
 * Admin Customizer settings.
 *
 * @return array
 */

$category = _x('Admin Customizer', 'Admin - Theme Options', 'uicore-framework');
$category_slug = 'admin-customizer'; // TODO: verify this

return [
    self::add_toggle([
        'id' => 275,
        'index' => 'admin_customizer',
        'adv' => true,
        'name' => _x('Enable Admin Customizer', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Use this feature to customize WP admin and theme options panel.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer enable', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_input([
        'id' => 276,
        'index' => 'theme_name',
        'adv' => true,
        'name' => _x('Theme Name', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Change theme name in WP dashboard.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer theme name', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '',
        'visible' => true,
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'text',
        'size' => 'l',
    ]),
    self::add_media([
        'id' => 277,
        'index' => 'admin_icon',
        'adv' => true,
        'name' => _x('Theme Icon', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Change theme icon in WP dashboard.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer theme icon', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_media([
        'id' => 278,
        'index' => 'to_logo',
        'adv' => true,
        'name' => _x('Theme Logo', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Change logo in theme options (top left).', 'uicore-framework'),
        'tags' => _x('admin customizer theme logo', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_color([
        'id' => 279,
        'index' => 'to_color',
        'adv' => true,
        'name' => _x('Panel Main Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Change main color in theme options panel.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer theme color', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '#532df5',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_editor([
        'id' => 280,
        'index' => 'to_content',
        'adv' => true,
        'name' => _x('Dashboard Content', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Change content in dashboard tab. HTML is allowed.', 'uicore-framework'),
        'tags' => _x('admin customizer dashboard content', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_color([
        'id' => 288,
        'index' => 'wp_background',
        'adv' => true,
        'name' => _x('Login Background', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Change the login screen background color.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer login background', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '#f0f0f1',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_color([
        'id' => 294,
        'index' => 'wp_text_bg_color',
        'adv' => true,
        'name' => _x('Login Screen Text Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Change the login screen text color.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer text color', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '#50575e',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_color([
        'id' => 289,
        'index' => 'wp_form_background',
        'adv' => true,
        'name' => _x('Login Form Background', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Change the login form background color.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer login form background', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '#ffffff',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_color([
        'id' => 290,
        'index' => 'wp_text_color',
        'adv' => true,
        'name' => _x('Login Form Text Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Change the login form text color.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer login text color', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '#50575e',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_color([
        'id' => 291,
        'index' => 'wp_button_background',
        'adv' => true,
        'name' => _x('Login Primary Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Change the login screen primary color.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer login primary color', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '#2271b1',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_media([
        'id' => 292,
        'index' => 'wp_logo',
        'adv' => true,
        'name' => _x('Login Screen Logo', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Change the login screen logo (replaces WordPress logo).', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer login logo', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_input([
        'id' => 293,
        'index' => 'wp_logo_height',
        'adv' => true,
        'name' => _x('WordPress Login Logo Height', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the height of the login logo (px).', 'uicore-framework'),
        'tags' => _x('wp login logo height', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '40',
        'visible' => true,
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'number',
        'size' => 's',
        'min' => 5,
        'max' => 100,
        'suffix' => 'px',
    ]),
    self::add_toggle([
        'id' => 287,
        'index' => 'advanced_mode',
        'adv' => true,
        'name' => _x('Allow Advanced Settings', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Turn off to hide advanced settings (marked with a colored dot).', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer advanced settings', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 286,
        'index' => 'to_reset',
        'adv' => true,
        'name' => _x('Disable Settings Reset', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Hide the Reset Settings button in System tab.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer updates', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 281,
        'index' => 'to_documentation',
        'adv' => true,
        'name' => _x('Disable Documentation Icon', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Hide the documentation icon on top right.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer documentation icon', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 282,
        'index' => 'to_import',
        'adv' => true,
        'name' => _x('Disable Demo Import', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Hide the demo import tab.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer demo import', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 417,
        'index' => 'disable_library',
        'adv' => true,
        'name' => _x('Disable Library', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Hide the library option on Elementor Editor.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer block import', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 283,
        'index' => 'to_performance',
        'adv' => true,
        'name' => _x('Disable Performance Manager', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Hide the performance tab.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer performance', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 284,
        'index' => 'to_plugins',
        'adv' => true,
        'name' => _x('Disable Plugins Manager', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Hide the plugins tab.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer plugins', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 285,
        'index' => 'to_updates',
        'adv' => true,
        'name' => _x('Disable Updates', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Hide the updates tab.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer updates', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 345,
        'index' => 'to_system',
        'adv' => true,
        'name' => _x('Disable System', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Hide the system tab.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer system', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 313,
        'index' => 'to_custom',
        'adv' => true,
        'name' => _x('Disable Custom Code', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Hide the Custom Code tab.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer custom code', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 314,
        'index' => 'to_typo',
        'adv' => true,
        'name' => _x('Disable Typography', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Hide the Typography tab.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer typography', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 315,
        'index' => 'to_ep',
        'adv' => true,
        'name' => _x('Disable Element Pack Pro Menu', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Hide Element Pack Pro menu from WordPress dashboard.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer element pack', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 309,
        'index' => 'disable_blog',
        'adv' => true,
        'name' => _x('Disable Blog', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Disable blog functionality.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer blog', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 310,
        'index' => 'disable_portfolio',
        'adv' => true,
        'name' => _x('Disable Portfolio', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Disable portfolio functionality.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer portfolio', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 311,
        'index' => 'disable_woocomerce',
        'adv' => true,
        'name' => _x('Disable WooComerce', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Disable WooCommerce functionality.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer woocommerce', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 312,
        'index' => 'disable_tb',
        'adv' => true,
        'name' => _x('Disable Theme Builder', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Disable Theme Builder functionality.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('admin customizer theme builder', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
];
