jQuery(window).on('elementor/frontend/init', () => {
  const applyShapeToWrapper = () => {
    jQuery('.bdt-shape-builder').each((i, el) => {
      const $el = jQuery(el);
      const wrapperClass = $el.data('wrapper-id');

      if (wrapperClass) {
        const $wrapper = jQuery(`.${wrapperClass}`);

        // Ensure wrapper exists before appending
        if ($wrapper.length) {
          // Move shape inside wrapper
          $wrapper.append($el);
        }
      }
    });
  };

  // ✅ Trigger for Container (Flexbox layout)
  elementorFrontend.hooks.addAction('frontend/element_ready/container', applyShapeToWrapper);

  // ✅ Trigger for Section (Classic layout)
  elementorFrontend.hooks.addAction('frontend/element_ready/section', applyShapeToWrapper);

  // ✅ Trigger for Column
  elementorFrontend.hooks.addAction('frontend/element_ready/column', applyShapeToWrapper);

  // ✅ Trigger for Inner Section (legacy structure)
  elementorFrontend.hooks.addAction('frontend/element_ready/inner-section', applyShapeToWrapper);

  // ✅ Also run once when the page is fully loaded
  jQuery(window).on('load', applyShapeToWrapper);
});
